<?php
/**
 * The template for displaying comments.
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! post_type_supports( get_post_type(), 'comments' ) ) {
	return;
}

if ( ! have_comments() && ! comments_open() ) {
	return;
}

// Comment Reply Script.
if ( comments_open() && get_option( 'thread_comments' ) ) {
	wp_enqueue_script( 'comment-reply' );
}
?>
<section id="comments" class="comments-area">

	<?php if ( have_comments() ) : ?>
		<p class="title-comments">
			<?php
			$comments_number = get_comments_number();
			if ( '1' === $comments_number ) {
				printf( esc_html_x( 'One Response', 'comments title', 'hello-elementor' ) );
			} else {
				printf(
					esc_html( /* translators: 1: number of comments */
						_nx(
							'%1$s پاسخ',
							'%1$s پاسخ',
							$comments_number,
							'comments title',
							'hello-elementor'
						)
					),
					esc_html( number_format_i18n( $comments_number ) )
				);
			}
			?>
		</p>

		<?php the_comments_navigation(); ?>

	<ol class="comment-list">
		<?php
		wp_list_comments(
			[
				'style'       => 'ol',
				'short_ping'  => true,
				'avatar_size' => 42,
				'callback'    => 'my_custom_comment_format', // تابع کال‌بک سفارشی
			]
		);
		?>
	</ol><!-- .comment-list -->

		<?php the_comments_navigation(); ?>

<?php endif; // Check for have_comments(). ?>

<?php
comment_form(
	[
		'title_reply_before' => '<p id="reply-title" class="comment-reply-title">',
		'title_reply_after'  => '</p>',
	]
);
?>

</section><!-- .comments-area -->

<?php
// تابع سفارشی برای فرمت کامنت‌ها
function my_custom_comment_format( $comment, $args, $depth ) {
	?>
	<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<article id="div-comment-<?php comment_ID(); ?>" class="comment-body">
			<footer class="comment-meta">
				<div class="comment-author vcard">
					<?php echo get_avatar( $comment, 42 ); ?>
					<?php printf( '<b class="fn">%s</b>', get_comment_author_link() ); ?>
				</div><!-- .comment-author -->

				<div class="comment-metadata">
					<time datetime="<?php comment_time( 'c' ); ?>">
						<?php comment_date(); ?> در <?php comment_time(); ?> <!-- نمایش تاریخ و ساعت بدون لینک -->
					</time>
				</div><!-- .comment-metadata -->
			</footer><!-- .comment-meta -->

			<div class="comment-content">
				<?php comment_text(); ?>
			</div><!-- .comment-content -->

			<div class="reply">
				<?php
				comment_reply_link(
					array_merge(
						$args,
						[
							'depth'     => $depth,
							'max_depth' => $args['max_depth'],
						]
					)
				);
				?>
			</div><!-- .reply -->
		</article><!-- .comment-body -->
	</li>
	<?php
}
?>
